
(defproto tc-model-object-proto '(data? method-value correlation-matrix) () mv-model-object-proto) 


(defmeth tc-model-object-proto :data?
  (&optional (values nil set))
  (if set (setf (slot-value 'data?) values))
  (slot-value 'data?))


(defmeth tc-model-object-proto :correlation-matrix
  (&optional (values nil set))
  (if set (setf (slot-value 'correlation-matrix) values))
  (slot-value 'correlation-matrix))


(defmeth tc-model-object-proto :options ()
  (setf data? (send choice-item-proto :new 
                    (list "2x2 frequency table" 
                           "Two numeric variables in binary format"
                           "More than 2 numeric variables in binary format")
                     :value 0))
  (setf OK (send modal-button-proto :new "Ok"
                 :action
               #'(lambda ()
                   (let (
                         (dialog (send ok :dialog))
                         )
                     (send self :data? (send data? :value))
                     ))))
                     
  (setf cancel (send modal-button-proto :new "Cancel"
                     :action
               #'(lambda ()
                   (let (
                         (dialog (send cancel :dialog))
                         )
                     (send dialog :modal-dialog-return nil)))))



(setf vista-tc-dialog
      (send modal-dialog-proto :new 
            (list 
             (list (list "Compute Tetrachoric correlation for:" data?))
             (list ok cancel))
			:default-button ok :title "Tetrachoric correlation"
            ))
(setf result (send vista-tc-dialog :modal-dialog))
             result)


(defmeth tc-model-object-proto :analysis ()

 ;(send self :correlation-matrix (tetrachoric4))
  )


(defmeth tc-model-object-proto :Report
  (&key (stream t) 
        (dialog nil))
;(if (not (eq current-object self)) (setcm self))
  (let* ((w nil)
         (var-labels (send self :variables))
         ;(nvars (send self :nvars))
         ;(nobs (send self :nobs))        
         )
          (setf w (report-header (send self :title "Tetrachoric Correlation Report")))   
 (display-string (format nil "~%Tetrachoric-Correlation plugin~%by Ruben D. Ledesma (2009)~2%MODEL: ~a~%" (send self :name)) w)

 (cond  
   ((= (send self :data?) 0) (display-string  (tetrachoric1 (send current-data :data)) w))
   ((= (send self :data?) 1)  
    (display-string (format nil "VARIABLES: ~a~2%" var-labels ) w)
   (display-string (tetrachoric2) w))

   ((= (send self :data?) 2)   
    (display-string (format nil "VARIABLES: ~a~2%" var-labels ) w)
    (display-string (format nil "~%Tetrachoric correlations matrix:~%") w)
    (print-matrix-to-window (send self :correlation-matrix (tetrachoric4))  w  :column-heading "" :row-heading nil :row-labels  var-labels :column-labels  var-labels :decimals 3)
    )
 (send w :fit-window-to-text)
   )

    )
  )



(defun Tetrachoric1  (f); requiere lista con las frecuencias de la tabla como input 
  (let* (
         (f11 (first f))
         (f12 (second f))
         (f21 (third f))
         (f22 (fourth f))
         (n (+ f11 f12 f21 f22))        
         (p1+ (+  (/ f11 n) (/ f12 n)))  
         (p+1 (+  (/ f11 n) (/ f21 n)))         
         (p2+ (+  (/ f21 n) (/ f22 n)))
         (p+2 (+  (/ f12 n) (/ f22 n)))        
         (pmin (min p1+ p+1 p2+ p+2))
         (w  (/ (* (+ f11 .5 ) (+ f22 .5)) (* (+ f12 .5) (+ f21 .5))))
         (c (/ (- 1 (/ (abs (- p1+ p+1)) 5) (^(- .5 pmin) 2)) 2))
         (coef (cos (/ pi (+ 1 (^ w c)))))
         (se-lnw  (^ (+ (^ (+ f11 .5) -1)  (^ (+ f12 .5) -1) (^(+ f21 .5) -1) (^ (+ f22 .5) -1)) (/ 1 2)))
         (lower-val (cos (/ pi (+ 1 (^ (exp (- (log w) (* 1.96 se-lnw))) c)))))
         (upper-val (cos (/ pi (+ 1 (^ (exp (+ (log w) (* 1.96 se-lnw))) c)))))
         )
    (format nil "Tetrachoric correlation coefficient: ~0,4f~% 95% Confidence Interval: (~0,4f ~0,4f)" coef lower-val upper-val)
    )
  )
    
;Ejemplo1 Bonett and Price
;(Tetrachoric (list 203 186 167 374)


;
;        X
;      1   0 
;Y 1  f11 f12  f1+  
;  0  f21 f22  f2+
;     f+1 f+2   n  

(defun Tetrachoric2 () ;;se aplica cuando hay dos variables activas en los datos actuales.
  (let* (
         (dat2 (send current-data :active-data-matrix '(numeric)))
         (n (send current-data :active-nobs))
         (data (mapcar '(lambda (x) (coerce x 'list)) (row-list dat2)))
         (f11 (length  (select data (which (map-elements  'equal (repeat 
'((1 1)) n) data)))))
         (f12 (length  (select data (which (map-elements  'equal (repeat '((0 1)) n) data)))))
         (f21 (length  (select data (which (map-elements  'equal (repeat 
                                                                  '((1 0)) n) data)))))
         (f22 (length  (select data (which (map-elements  'equal (repeat '((0 0)) n) data)))))
         (p1+ (+  (/ f11 n) (/ f12 n)))  
         (p+1 (+  (/ f11 n) (/ f21 n)))         
         (p2+ (+  (/ f21 n) (/ f22 n)))
         (p+2 (+  (/ f12 n) (/ f22 n)))        
         (pmin (min p1+ p+1 p2+ p+2))
         (w  (/ (* (+ f11 .5 ) (+ f22 .5)) (* (+ f12 .5) (+ f21 .5))))
         (c (/ (- 1 (/ (abs (- p1+ p+1)) 5) (^(- .5 pmin) 2)) 2))
         (coef (cos (/ pi (+ 1 (^ w c)))))
         (se-lnw  (^ (+ (^ (+ f11 .5) -1)  (^ (+ f12 .5) -1) (^(+ f21 .5) -1) (^ (+ f22 .5) -1)) (/ 1 2)))
         (lower-val (cos (/ pi (+ 1 (^ (exp (- (log w) (* 1.96 se-lnw))) c)))))
         (upper-val (cos (/ pi (+ 1 (^ (exp (+ (log w) (* 1.96 se-lnw))) c)))))
         )
    (format nil "Tetrachoric correlation coefficient: ~0,4f~% 95% Confidence Interval: (~0,4f ~0,4f)" coef lower-val upper-val)))


(defun Tetrachoric3 (x y) ;;tomas dos variables de los datos actuales, x e y son las posiciones en la matrix, arroja solo el coef.
  (let* (
         (dat1 (send current-data :active-data-matrix '(numeric)))
         (n (send current-data :active-nobs))
         (dat2 (transpose (make-array (list 2 n) :initial-contents (combine (select  (column-list dat1) (list x y))))))
         (data (mapcar '(lambda (x) (coerce x 'list)) (row-list dat2)))
         (f11 (length  (select data (which (map-elements  'equal (repeat 
'((1 1)) n) data)))))
         (f12 (length  (select data (which (map-elements  'equal (repeat '((0 1)) n) data)))))
         (f21 (length  (select data (which (map-elements  'equal (repeat 
                                                                  '((1 0)) n) data)))))
         (f22 (length  (select data (which (map-elements  'equal (repeat '((0 0)) n) data)))))
         (p1+ (+  (/ f11 n) (/ f12 n)))  
         (p+1 (+  (/ f11 n) (/ f21 n)))         
         (p2+ (+  (/ f21 n) (/ f22 n)))
         (p+2 (+  (/ f12 n) (/ f22 n)))        
         (pmin (min p1+ p+1 p2+ p+2))
         (w  (/ (* (+ f11 .5 ) (+ f22 .5)) (* (+ f12 .5) (+ f21 .5))))
         (c (/ (- 1 (/ (abs (- p1+ p+1)) 5) (^(- .5 pmin) 2)) 2))
         )        
    (setf coef (cos (/ pi (+ 1 (^ w c)))))
))
          


(defun Tetrachoric4 () ;;tomas las variables actuales y aplica Tetrachoric3, arroja una matriz de correlaciones tetracricas
  (let* (
         (nvar (send current-data :active-nvar '(numeric)))
         (coefs (mapcar #'(lambda (z) (mapcar #'(lambda (x y) (Tetrachoric3 x y)) (repeat z (- nvar z)) (iseq (+ 1 z) (- nvar 1)))) (iseq (- nvar 1))))
         (index (mapcar #'(lambda (z) (mapcar #'(lambda (x y) (list x y)) (repeat z (- nvar z)) (iseq (+ 1 z) (- nvar 1)))) (iseq (- nvar 1))))
         (index2 (split-list (combine index) 2))   
         )
    (setf m (make-array (list nvar nvar)))
    
    (mapcar #'(lambda (x y) 
                (setf (aref m 
                            (select (select index2 x) 0)
                            (select (select index2 x) 1)) 
                      y)) (iseq (length index2)) (combine coefs)
            )
    (mapcar #'(lambda (x y) 
                (setf (aref m 
                            (select (select index2 x) 1)
                            (select (select index2 x) 0)) 
                      y)) (iseq (length index2)) (combine coefs)
            )
    (replace-diagonal m (repeat 1 nvar)))
  m)